package cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 车辆信息分页 Request VO")
@Data
public class VehicleInfoPageReqVO extends PageParam {

    @Schema(description = "车牌号")
    private String licensePlate;

    @Schema(description = "车型", example = "2")
    private String vehicleType;

    @Schema(description = "载重 (kg)")
    private Integer loadWeight;

    @Schema(description = "容积 (m³)")
    private BigDecimal volume;

    @Schema(description = "车辆绑定人员")
    private Long vehicleStaff;

    @Schema(description = "车辆绑定人员名称", example = "王五")
    private String vehicleStaffName;

    @Schema(description = "人员出生年份")
    private Integer staffYearBirth;

    @Schema(description = "人员联系方式")
    private String staffPhone;

    @Schema(description = "人员健康状态", example = "1")
    private String staffHealthStatus;

    @Schema(description = "人员驾驶证状态", example = "2")
    private String staffLicenseStatus;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "创建人")
    private String creator;

}