package cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;

@Schema(description = "管理后台 - 车辆信息新增/修改 Request VO")
@Data
public class VehicleInfoBindReqVO {

    @Schema(description = "序号，自增主键", requiredMode = Schema.RequiredMode.REQUIRED, example = "7574")
    private Long id;

    @Schema(description = "车辆绑定人员")
    @NotNull(message = "车辆绑定人员不能为空")
    private Long vehicleStaff;

    @Schema(description = "车辆绑定人员名称", example = "王五")
    private String vehicleStaffName;

    @Schema(description = "人员出生年份")
    private Integer staffYearBirth;

    @Schema(description = "人员联系方式")
    private String staffPhone;

    @Schema(description = "人员健康状态", example = "1")
    private String staffHealthStatus;

    @Schema(description = "人员驾驶证状态", example = "2")
    private String staffLicenseStatus;

}