package cn.iocoder.foodnexus.module.erp.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import cn.iocoder.foodnexus.module.erp.enums.stock.ErpStockRecordBizTypeEnum;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/9/25  14:58
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SaleOrderPickUpStatus implements ArrayValuable<String> {

    TO_BE("TO_BE", "待拣"),

    PICK_UP("PICK_UP", "已拣"),


    ;

    public static final String[] ARRAYS = Arrays.stream(values()).map(SaleOrderPickUpStatus::getType).toArray(String[]::new);

    /**
     * 类型
     */
    private final String type;
    /**
     * 名字
     */
    private final String name;

    @Override
    public String[] array() {
        return ARRAYS;
    }
}
