package cn.iocoder.foodnexus.module.order.dal.dataobject.shoppingcart;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 购物车 DO
 *
 * @author 超级管理员
 */
@TableName("order_shopping_cart")
@KeySequence("order_shopping_cart_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShoppingCartDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 商品id
     */
    private Long productId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 单价(分)
     */
    private Integer unitPrice;
    /**
     * 下单数量
     */
    private Integer orderQuantity;
    /**
     * 备注
     */
    private String remark;


}