package cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 客户 - 我的地址 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CustomerAddressRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "15256")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "17120")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "联系人", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("联系人")
    private String contactUser;

    @Schema(description = "联系号码", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("联系号码")
    private String contactPhone;

    @Schema(description = "省id", example = "24818")
    @ExcelProperty("省id")
    private Long provinceId;

    @Schema(description = "省name", example = "李四")
    @ExcelProperty("省name")
    private String provinceName;

    @Schema(description = "市", example = "22031")
    @ExcelProperty("市")
    private Long cityId;

    @Schema(description = "市", example = "张三")
    @ExcelProperty("市")
    private String cityName;

    @Schema(description = "区", example = "3268")
    @ExcelProperty("区")
    private Long regionId;

    @Schema(description = "区", example = "赵六")
    @ExcelProperty("区")
    private String regionName;

    @Schema(description = "详细地址")
    @ExcelProperty("详细地址")
    private String address;

    @Schema(description = "是否默认", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("是否默认")
    private Boolean isDefault;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}