package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.idev.excel.annotation.ExcelProperty;
import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/14  10:16
 * @description: 退货说明
 */
@Data
public class AppCustomerOrderReturnRespVO {

    @Schema(description = "退货单id")
    private Long saleReturnId;

    @Schema(description = "说明")
    private String remark;

    @Schema(description = "相关文件")
    private List<String> remarkFiles;

    @Schema(description = "最终合计价格,单位:分", requiredMode = Schema.RequiredMode.REQUIRED, example = "24906")
    private Integer totalReturnPrice;

    @Schema(description = "退货子项")
    private List<ReturnItems> returnItems;

    @Data
    public static class ReturnItems {

        @Schema(description = "客户子订单id")
        private Long customerOrderItemId;

        @Schema(description = "商品id")
        private Long productId;

        @Schema(description = "商品基本信息")
        private ProductInfo productInfo;

        @Schema(description = "订单商品单价，单位：分")
        private Integer orderItemPrice;

        @Schema(description = "退货数量")
        private Integer returnCount;

        @Schema(description = "退货金额,单位：分")
        private Integer returnPrice;

        @Schema(description = "退货总金额,单位：分")
        private Integer totalReturnPrice;

        @Schema(description = "备注")
        private String remark;

    }

}
