package cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户需求分页 Request VO")
@Data
public class CustomerRequirePageReqVO extends PageParam {

    @Schema(description = "客户id", example = "23236")
    private Long customerId;

    @Schema(description = "需求标题")
    private String requireTitle;

    @Schema(description = "需求内容")
    private String requireContent;

    @Schema(description = "商品分类编号", example = "28601")
    private Long categoryId;

    @Schema(description = "是否受理")
    private Boolean isRequire;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "更新时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] updateTime;

    @Schema(description = "创建人")
    private Long creator;

}