package cn.iocoder.foodnexus.module.erp.controller.admin.customerwarehouse.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 客户绑定仓库新增/修改 Request VO")
@Data
public class CustomerWarehouseSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "11798")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "24072")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30163")
    @NotNull(message = "仓库id不能为空")
    private Long warehouseId;

    @Schema(description = "库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "18079")
    @NotNull(message = "库区id不能为空")
    private Long warehouseAreaId;

}