package cn.iocoder.foodnexus.module.order.dto;

import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import lombok.Data;

/**
 * @author : yanghao
 * create at:  2025/9/22  15:36
 * @description: 客户子订单
 */
@Data
public class CustomerOrderItemDTO {

    /**
     * id
     */
    private Long id;
    /**
     * 客户订单id
     */
    private Long orderId;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 商品id
     */
    private Long productId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品信息
     */
    private ProductInfo productInfo;
    /**
     * 商品对应供应商id
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 订单商品单价，单位：分
     */
    private Integer orderItemPrice;
    /**
     * 订单商品总价，单位：分
     */
    private Integer orderItemTotal;
    /**
     * 订单商品数量
     */
    private Integer orderItemQuantity;
    /**
     * 签收数量
     */
    private Integer signedQuantity;
    /**
     * 签收总价，单位：分
     */
    private Integer signedTotal;
    /**
     * 订单备注
     */
    private CustomerOrderRemark orderRemark;
    /**
     * 客户下单备注
     */
    private String customerRemark;
}
