package cn.iocoder.foodnexus.module.erp.dal.mysql.customerwarehouse;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.customerwarehouse.CustomerWarehouseDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.erp.controller.admin.customerwarehouse.vo.*;

/**
 * 客户绑定仓库 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerWarehouseMapper extends BaseMapperX<CustomerWarehouseDO> {

    default PageResult<CustomerWarehouseDO> selectPage(CustomerWarehousePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerWarehouseDO>()
                .eqIfPresent(CustomerWarehouseDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerWarehouseDO::getWarehouseId, reqVO.getWarehouseId())
                .eqIfPresent(CustomerWarehouseDO::getWarehouseAreaId, reqVO.getWarehouseAreaId())
                .betweenIfPresent(CustomerWarehouseDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CustomerWarehouseDO::getId));
    }

}