package cn.iocoder.foodnexus.module.order.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/9/24  17:08
 * @description: 来料质检状态
 */
@Getter
@AllArgsConstructor
public enum CheckTaskStatus implements ArrayValuable<String> {


    TO_BE_CHECK( "待质检", "TO_BE_CHECK"),

    NORMAL( "质检合格", "NORMAL"),

    ABNORMAL( "质检不合格", "ABNORMAL"),


    ;

    private final String label;
    private final String key;

    public static final String[] ARRAYS = Arrays.stream(values()).map(CheckTaskStatus::getKey).toArray(String[]::new);

    /**
     * @return 数组
     */
    @Override
    public String[] array() {
        return ARRAYS;
    }
}
