package cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirecustomerpush;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 询价推送-客户 DO
 *
 * @author 超级管理员
 */
@TableName("oper_inquire_customer_push")
@KeySequence("oper_inquire_customer_push_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InquireCustomerPushDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 询价主题id
     */
    private Long inquirePriceId;
    /**
     * 是否确认
     */
    private Boolean confirm;
    /**
     * 确认人员
     */
    private Long confirmUser;
    /**
     * 确认时间
     */
    private LocalDateTime confirmTime;


}