package cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 配送员信息分页 Request VO")
@Data
public class DeliveryStaffPageReqVO extends PageParam {

    @Schema(description = "姓名", example = "芋艿")
    private String name;

    @Schema(description = "身份证号")
    private String idNumber;

    @Schema(description = "联系方式")
    private String contact;

    @Schema(description = "在岗状态", example = "1")
    private String onDutyStatus;

    @Schema(description = "人员出生年份")
    private Integer staffYearBirth;

    @Schema(description = "健康状态", example = "1")
    private String healthStatus;

    @Schema(description = "驾驶证类型", example = "1")
    private String driverLicenseType;

    @Schema(description = "驾驶证有效期开始时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] licenseStartTime;

    @Schema(description = "驾驶证有效期结束时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] licenseEndTime;

    @Schema(description = "驾驶证状态", example = "1")
    private String driverLicenseStatus;

    @Schema(description = "健康证明文件路径")
    private String healthCertificateFile;

    @Schema(description = "机动车驾驶证图片路径")
    private String driverLicenseFile;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}