package cn.iocoder.foodnexus.module.order.service.shoppingcart;

import cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo.ShoppingCartPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo.ShoppingCartSaveReqVO;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;

import java.util.*;

import cn.iocoder.foodnexus.module.order.dal.dataobject.shoppingcart.ShoppingCartDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.order.dal.mysql.shoppingcart.ShoppingCartMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.module.order.enums.ErrorCodeConstants.*;

/**
 * 购物车 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class ShoppingCartServiceImpl implements ShoppingCartService {

    @Resource
    private ShoppingCartMapper shoppingCartMapper;

    @Override
    public Long createShoppingCart(ShoppingCartSaveReqVO createReqVO) {
        // 插入
        ShoppingCartDO shoppingCart = BeanUtils.toBean(createReqVO, ShoppingCartDO.class);
        shoppingCartMapper.insert(shoppingCart);

        // 返回
        return shoppingCart.getId();
    }

    @Override
    public void updateShoppingCart(ShoppingCartSaveReqVO updateReqVO) {
        // 校验存在
        validateShoppingCartExists(updateReqVO.getId());
        // 更新
        ShoppingCartDO updateObj = BeanUtils.toBean(updateReqVO, ShoppingCartDO.class);
        shoppingCartMapper.updateById(updateObj);
    }

    @Override
    public void deleteShoppingCart(Long id) {
        // 校验存在
        validateShoppingCartExists(id);
        // 删除
        shoppingCartMapper.deleteById(id);
    }

    @Override
        public void deleteShoppingCartListByIds(List<Long> ids) {
        // 删除
        shoppingCartMapper.deleteByIds(ids);
        }


    private void validateShoppingCartExists(Long id) {
        if (shoppingCartMapper.selectById(id) == null) {
            throw exception(SHOPPING_CART_NOT_EXISTS);
        }
    }

    @Override
    public ShoppingCartDO getShoppingCart(Long id) {
        return shoppingCartMapper.selectById(id);
    }

    @Override
    public PageResult<ShoppingCartDO> getShoppingCartPage(ShoppingCartPageReqVO pageReqVO) {
        return shoppingCartMapper.selectPage(pageReqVO);
    }

}