package cn.iocoder.foodnexus.module.order.service.customeraddress;

import java.util.*;

import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressSaveReqVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customeraddress.CustomerAddressDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;

/**
 * 客户 - 我的地址 Service 接口
 *
 * @author 超级管理员
 */
public interface CustomerAddressService {

    /**
     * 创建客户 - 我的地址
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCustomerAddress(@Valid CustomerAddressSaveReqVO createReqVO);

    /**
     * 更新客户 - 我的地址
     *
     * @param updateReqVO 更新信息
     */
    void updateCustomerAddress(@Valid CustomerAddressSaveReqVO updateReqVO);

    /**
     * 删除客户 - 我的地址
     *
     * @param id 编号
     */
    void deleteCustomerAddress(Long id);

    /**
    * 批量删除客户 - 我的地址
    *
    * @param ids 编号
    */
    void deleteCustomerAddressListByIds(List<Long> ids);

    /**
     * 获得客户 - 我的地址
     *
     * @param id 编号
     * @return 客户 - 我的地址
     */
    CustomerAddressDO getCustomerAddress(Long id);

    /**
     * 获得客户 - 我的地址分页
     *
     * @param pageReqVO 分页查询
     * @return 客户 - 我的地址分页
     */
    PageResult<CustomerAddressDO> getCustomerAddressPage(CustomerAddressPageReqVO pageReqVO);

    boolean existsById(Long addressId);
}