package cn.iocoder.foodnexus.module.order.dal.mysql.customeraddress;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo.CustomerAddressPageReqVO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customeraddress.CustomerAddressDO;
import org.apache.ibatis.annotations.Mapper;

/**
 * 客户 - 我的地址 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerAddressMapper extends BaseMapperX<CustomerAddressDO> {

    default PageResult<CustomerAddressDO> selectPage(CustomerAddressPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerAddressDO>()
                .eqIfPresent(CustomerAddressDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerAddressDO::getContactUser, reqVO.getContactUser())
                .eqIfPresent(CustomerAddressDO::getContactPhone, reqVO.getContactPhone())
                .eqIfPresent(CustomerAddressDO::getProvinceId, reqVO.getProvinceId())
                .likeIfPresent(CustomerAddressDO::getProvinceName, reqVO.getProvinceName())
                .eqIfPresent(CustomerAddressDO::getCityId, reqVO.getCityId())
                .likeIfPresent(CustomerAddressDO::getCityName, reqVO.getCityName())
                .eqIfPresent(CustomerAddressDO::getRegionId, reqVO.getRegionId())
                .likeIfPresent(CustomerAddressDO::getRegionName, reqVO.getRegionName())
                .eqIfPresent(CustomerAddressDO::getAddress, reqVO.getAddress())
                .eqIfPresent(CustomerAddressDO::getIsDefault, reqVO.getIsDefault())
                .betweenIfPresent(CustomerAddressDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CustomerAddressDO::getId));
    }

}