package cn.iocoder.foodnexus.module.order.dal.mysql.checktask;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktask.CheckTaskDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.*;

/**
 * 来料质检 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CheckTaskMapper extends BaseMapperX<CheckTaskDO> {

    default PageResult<CheckTaskDO> selectPage(CheckTaskPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CheckTaskDO>()
                .eqIfPresent(CheckTaskDO::getNo, reqVO.getNo())
                .eqIfPresent(CheckTaskDO::getStatus, reqVO.getStatus())
                .eqIfPresent(CheckTaskDO::getSupplierId, reqVO.getSupplierId())
                .eqIfPresent(CheckTaskDO::getPurchaseOrderId, reqVO.getPurchaseOrderId())
                .eqIfPresent(CheckTaskDO::getCustomerOrderId, reqVO.getCustomerOrderId())
                .eqIfPresent(CheckTaskDO::getCustomerId, reqVO.getCustomerId())
                .betweenIfPresent(CheckTaskDO::getArrivalTime, reqVO.getArrivalTime())
                .eqIfPresent(CheckTaskDO::getRemark, reqVO.getRemark())
                .eqIfPresent(CheckTaskDO::getFiles, reqVO.getFiles())
                .betweenIfPresent(CheckTaskDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CheckTaskDO::getId));
    }

}