package cn.iocoder.foodnexus.module.order.dal.dataobject.checktaskitems;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 来料质检清单 DO
 *
 * @author 超级管理员
 */
@TableName("order_check_task_items")
@KeySequence("order_check_task_items_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CheckTaskItemsDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 来料质检id
     */
    private Long checkTaskId;
    /**
     * 商品id
     */
    private Long productId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品分类
     */
    private Long categoryId;
    /**
     * 商品分类名称
     */
    private String categoryName;
    /**
     * 商品封面图
     */
    private String picUrl;
    /**
     * 检查数量
     */
    private Integer checkCount;
    /**
     * 商品单位
     */
    private String unitName;
    /**
     * 质检结果
     *
     * 枚举 {@link TODO order_check_task_status 对应的类}
     */
    private String checkResult;


}