package cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo;

import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderrecord.vo.CustomerOrderRecordRespVO;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder.CustomerOrderRemark;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.time.LocalDateTime;
import java.util.List;

import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 客户总订单 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CustomerOrderRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19291")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "订单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("订单编号")
    private String code;

    @Schema(description = "订单状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @ExcelProperty(value = "订单状态", converter = DictConvert.class)
    @DictFormat("order_customer_order_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private CustomerOrderStatus orderStatus;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "20189")
    @ExcelProperty("客户id")
    private Long customerId;

    private String customerName;

    @Schema(description = "收获仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "27065")
    @ExcelProperty("收获仓库id")
    private Long warehouseId;

    @Schema(description = "收获库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "26507")
    @ExcelProperty("收获库区id")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    @ExcelProperty("仓库信息")
    private WarehouseInfo warehouseInfo;

    @Schema(description = "客户收货地址id")
    private Long addressId;

    @Schema(description = "客户收货地址info")
    private CustomerAddressInfo addressInfo;

    @Schema(description = "配送模式", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty(value = "配送模式", converter = DictConvert.class)
    @DictFormat("order_delivery_mode") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private DeliveryMode deliveryMode;

    @Schema(description = "采购订单数", requiredMode = Schema.RequiredMode.REQUIRED, example = "12099")
    @ExcelProperty("采购订单数")
    private Integer productCount;

    @Schema(description = "供应商数", example = "8062")
    @ExcelProperty("供应商数")
    private Integer supplierCount;

    @Schema(description = "预计配送开始时间")
    @ExcelProperty("预计配送开始时间")
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    @ExcelProperty("预计配送结束时间")
    private LocalDateTime planDeliveryEndTime;

    @Schema(description = "订单总金额(分)", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("订单总金额(分)")
    private Integer orderAmount;

    @Schema(description = "实际支付总金额(分)")
    @ExcelProperty("实际支付总金额(分)")
    private Integer actualAmount;

    @Schema(description = "配送公司")
    @ExcelProperty("配送公司")
    private String operCompany;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "订单备注")
    private CustomerOrderRemark orderRemark;

    @Schema(description = "当前订单进度")
    private List<CustomerOrderRecordRespVO> currentRecords;

}