package cn.iocoder.foodnexus.module.operations.dal.mysql.inquirecustomerpush;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.query.MPJLambdaWrapperX;
import cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo.AppInquireCustomerPushPageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquirecustomerpush.vo.AppInquireCustomerPushRespVO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirecustomerpush.InquireCustomerPushDO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquireprice.InquirePriceDO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirepriceitem.InquirePriceItemDO;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquirecustomerpush.vo.*;

/**
 * 询价推送-客户 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface InquireCustomerPushMapper extends BaseMapperX<InquireCustomerPushDO> {

    default PageResult<InquireCustomerPushDO> selectPage(InquireCustomerPushPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<InquireCustomerPushDO>()
                .eqIfPresent(InquireCustomerPushDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(InquireCustomerPushDO::getInquirePriceId, reqVO.getInquirePriceId())
                .eqIfPresent(InquireCustomerPushDO::getConfirm, reqVO.getConfirm())
                .eqIfPresent(InquireCustomerPushDO::getConfirmUser, reqVO.getConfirmUser())
                .betweenIfPresent(InquireCustomerPushDO::getConfirmTime, reqVO.getConfirmTime())
                .betweenIfPresent(InquireCustomerPushDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(InquireCustomerPushDO::getId));
    }

    default PageResult<AppInquireCustomerPushRespVO> selectPage(AppInquireCustomerPushPageReqVO reqVO) {
        MPJLambdaWrapper<InquireCustomerPushDO> wrapperX = new MPJLambdaWrapper<InquireCustomerPushDO>()
                .selectAll(InquireCustomerPushDO.class)
                .selectCount(InquirePriceItemDO::getId, "inquirePriceItemCount")
                .leftJoin(InquirePriceDO.class, InquirePriceDO::getId, InquireCustomerPushDO::getInquirePriceId)
                .leftJoin(InquirePriceItemDO.class, InquirePriceItemDO::getInquireId, InquirePriceDO::getId)
                .eq(InquireCustomerPushDO::getCustomerId, reqVO.getCustomerId())
                .eqIfExists(InquireCustomerPushDO::getInquirePriceId, reqVO.getInquirePriceId())
                .eqIfExists(InquireCustomerPushDO::getConfirm, reqVO.getConfirm())
                .eqIfExists(InquireCustomerPushDO::getConfirmUser, reqVO.getConfirmUser())
                .between(CommonUtil.isNotEmpty(reqVO.getConfirmTime()), InquireCustomerPushDO::getConfirmTime, reqVO.getConfirmTime()[0], reqVO.getConfirmTime()[1])
                .between(CommonUtil.isNotEmpty(reqVO.getCreateTime()), InquireCustomerPushDO::getCreateTime, reqVO.getCreateTime()[0], reqVO.getCreateTime()[1])
                .eqIfExists(InquirePriceDO::getInquiryYearMonth, reqVO.getInquiryYearMonth())
                .groupBy(InquireCustomerPushDO::getId)
                .orderByDesc(InquireCustomerPushDO::getId);
        return selectJoinPage(reqVO, AppInquireCustomerPushRespVO.class, wrapperX);
    }

    default List<InquirePriceItemDO> queryConfirmPush(Long customerId) {
        MPJLambdaWrapper<InquireCustomerPushDO> wrapper = new MPJLambdaWrapper<>();
        wrapper.selectAll(InquirePriceItemDO.class);
        wrapper.innerJoin(InquirePriceDO.class, InquirePriceDO::getId, InquireCustomerPushDO::getInquirePriceId);
        wrapper.innerJoin(InquirePriceItemDO.class, InquirePriceItemDO::getInquireId, InquirePriceDO::getId);
        wrapper.eq(InquireCustomerPushDO::getCustomerId, customerId);
        wrapper.eq(InquireCustomerPushDO::getConfirm, Boolean.TRUE);
        wrapper.eq(InquirePriceDO::getIsPush, Boolean.TRUE);
        return selectJoinList(InquirePriceItemDO.class, wrapper);
    }
}