package cn.iocoder.foodnexus.module.erp.controller.admin.stock.vo.warehouse;

import cn.iocoder.foodnexus.framework.common.enums.CommonStatusEnum;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.module.erp.api.enums.WarehouseLevelEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;

@Schema(description = "管理后台 - ERP 仓库新增/修改 Request VO")
@Data
public class ErpWarehouseSaveReqVO {

    @Schema(description = "仓库编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "11614")
    private Long id;

    @Schema(description = "仓库名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "李四")
    @NotEmpty(message = "仓库名称不能为空")
    private String name;

    @Schema(description = "仓库地址", example = "上海陆家嘴")
    private String address;

    @Schema(description = "排序", requiredMode = Schema.RequiredMode.REQUIRED, example = "10")
    @NotNull(message = "排序不能为空")
    private Long sort;

    @Schema(description = "备注", example = "随便")
    private String remark;

    @Schema(description = "负责人", example = "芋头")
    private String principal;

    @Schema(description = "联系电话", example = "18818288888")
    private String telephone;

    @Schema(description = "仓储费，单位：元", example = "13973")
    private BigDecimal warehousePrice;

    @Schema(description = "搬运费，单位：元", example = "9903")
    private BigDecimal truckagePrice;

    @Schema(description = "开启状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @NotNull(message = "开启状态不能为空")
    @InEnum(CommonStatusEnum.class)
    private Integer status;

    @Schema(description = "仓库等级", requiredMode = Schema.RequiredMode.REQUIRED, example = "warehouse")
    @NotBlank(message = "仓库等级不能为空")
    @InEnum(WarehouseLevelEnum.class)
    private String level;

    @Schema(description = "库区所属仓库id, level=warehouse为0", requiredMode = Schema.RequiredMode.REQUIRED, example = "0")
    @NotNull(message = "库区所属仓库id不能为空")
    private Long parentId;

}