package cn.iocoder.foodnexus.module.customerpermission.core.rule;

import java.util.List;

/**
 * {@link CustomerPermissionRule} 工厂接口
 * 作为 {@link CustomerPermissionRule} 的容器，提供管理能力
 *
 * @author 芋道源码
 */
public interface CustomerPermissionRuleFactory {

    /**
     * 获得所有数据权限规则数组
     *
     * @return 数据权限规则数组
     */
    List<CustomerPermissionRule> getCustomerPermissionRules();

    /**
     * 获得指定 Mapper 的数据权限规则数组
     *
     * @param mappedStatementId 指定 Mapper 的编号
     * @return 数据权限规则数组
     */
    List<CustomerPermissionRule> getCustomerPermissionRule(String mappedStatementId);

}
