package cn.iocoder.foodnexus.module.order.service.customerorderitem;

import cn.hutool.core.collection.CollUtil;
import cn.iocoder.foodnexus.module.erp.service.product.ErpProductService;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderItemSaveReqVO;
import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import cn.iocoder.foodnexus.module.product.service.spu.ProductSpuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderitem.CustomerOrderItemDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.order.dal.mysql.customerorderitem.CustomerOrderItemMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.order.enums.ErrorCodeConstants.*;

/**
 * 客户订单-子订单 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class CustomerOrderItemServiceImpl implements CustomerOrderItemService {

    @Resource
    private CustomerOrderItemMapper customerOrderItemMapper;

    @Autowired
    private ProductSpuService productSpuService;

    @Override
    public Long createCustomerOrderItem(CustomerOrderItemSaveReqVO createReqVO) {
        // 插入
        CustomerOrderItemDO customerOrderItem = BeanUtils.toBean(createReqVO, CustomerOrderItemDO.class);
        customerOrderItemMapper.insert(customerOrderItem);

        // 返回
        return customerOrderItem.getId();
    }

    @Override
    public void updateCustomerOrderItem(CustomerOrderItemSaveReqVO updateReqVO) {
        // 校验存在
        validateCustomerOrderItemExists(updateReqVO.getId());
        // 更新
        CustomerOrderItemDO updateObj = BeanUtils.toBean(updateReqVO, CustomerOrderItemDO.class);
        customerOrderItemMapper.updateById(updateObj);
    }

    @Override
    public void deleteCustomerOrderItem(Long id) {
        // 校验存在
        validateCustomerOrderItemExists(id);
        // 删除
        customerOrderItemMapper.deleteById(id);
    }

    @Override
        public void deleteCustomerOrderItemListByIds(List<Long> ids) {
        // 删除
        customerOrderItemMapper.deleteByIds(ids);
        }


    private void validateCustomerOrderItemExists(Long id) {
        if (customerOrderItemMapper.selectById(id) == null) {
            throw exception(CUSTOMER_ORDER_ITEM_NOT_EXISTS);
        }
    }

    @Override
    public CustomerOrderItemDO getCustomerOrderItem(Long id) {
        return customerOrderItemMapper.selectById(id);
    }

    @Override
    public PageResult<CustomerOrderItemDO> getCustomerOrderItemPage(CustomerOrderItemPageReqVO pageReqVO) {
        return customerOrderItemMapper.selectPage(pageReqVO);
    }

    @Override
    public void createBatch(List<AppCustomerOrderItemSaveReqVO> orderItems, Long customerOrderId, Long customerId) {
        List<CustomerOrderItemDO> items = BeanUtils.toBean(orderItems, CustomerOrderItemDO.class, item -> {
            item.setOrderId(customerOrderId);
            item.setCustomerId(customerId);
            item.setProductInfo(BeanUtils.toBean(productSpuService.getSpu(item.getProductId()),
                    ProductInfo.class));
            item.setSignedQuantity(0);
            item.setSignedTotal(0);
        });
        customerOrderItemMapper.insertBatch(items);
    }

}