package cn.iocoder.foodnexus.module.order.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/9/5  17:12
 * @description: 客户 - 订单 - 状态
 */
@Getter
@AllArgsConstructor
public enum CustomerOrderStatus implements ArrayValuable<String> {

    // 下单成功
    ORDER_SUCCESS("下单成功", "order_success"),
    // 订单匹配
    ORDER_MATCH("订单匹配", "order_match"),
    // 供应商接单
    SUPPLIER_ACCEPT_ORDER("供应商接单", "supplier_accept_order"),
    // 供应商发货
    SUPPLIER_SHIP("供应商发货", "supplier_ship"),
    // 供应商到货
    SUPPLIER_ARRIVE("供应商到货", "supplier_arrive"),

    ;

    private final String label;
    private final String key;

    public static final String[] ARRAYS = Arrays.stream(values()).map(CustomerOrderStatus::getKey).toArray(String[]::new);

    /**
     * @return 数组
     */
    @Override
    public String[] array() {
        return ARRAYS;
    }
}
