package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Schema(description = "管理后台 - 客户总订单新增/修改 Request VO")
@Data
public class AppCustomerOrderSaveReqVO {

    @Schema(description = "收获仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "27065")
    @NotNull(message = "收获仓库id不能为空")
    private Long warehouseId;

    @Schema(description = "收获库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "26507")
    @NotNull(message = "收获库区id不能为空")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    private WarehouseInfo warehouseInfo;

    @Schema(description = "配送模式", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "配送模式不能为空")
    private DeliveryMode deliveryMode;

    @Schema(description = "采购订单数", requiredMode = Schema.RequiredMode.REQUIRED, example = "12099")
    @NotNull(message = "采购订单数不能为空")
    @Size(min = 1, message = "采购订单数不能小于1")
    private Integer productCount;

    @Schema(description = "预计配送开始时间")
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    private LocalDateTime planDeliveryEndTime;

    @Schema(description = "配送公司")
    private String operCompany;

    @Schema(description = "orderItems")
    @Valid
    @NotNull(message = "订单子项不能为空")
    @Size(min = 1, message = "订单子项不能为空")
    private List<AppCustomerOrderItemSaveReqVO> orderItems;

}