package cn.iocoder.foodnexus.module.operations.service.inquiresupplierpush;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushConfirmReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushPageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushRespVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquiresupplierpush.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquiresupplierpush.InquireSupplierPushDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 询价推送 Service 接口
 *
 * @author 超级管理员
 */
public interface InquireSupplierPushService {

    /**
     * 创建询价推送
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createInquireSupplierPush(@Valid InquireSupplierPushSaveReqVO createReqVO);

    /**
     * 更新询价推送
     *
     * @param updateReqVO 更新信息
     */
    void updateInquireSupplierPush(@Valid InquireSupplierPushSaveReqVO updateReqVO);

    /**
     * 删除询价推送
     *
     * @param id 编号
     */
    void deleteInquireSupplierPush(Long id);

    /**
    * 批量删除询价推送
    *
    * @param ids 编号
    */
    void deleteInquireSupplierPushListByIds(List<Long> ids);

    /**
     * 获得询价推送
     *
     * @param id 编号
     * @return 询价推送
     */
    InquireSupplierPushDO getInquireSupplierPush(Long id);

    /**
     * 获得询价推送分页
     *
     * @param pageReqVO 分页查询
     * @return 询价推送分页
     */
    PageResult<InquireSupplierPushDO> getInquireSupplierPushPage(InquireSupplierPushPageReqVO pageReqVO);

    default void addBatch(List<InquireSupplierPushSaveReqVO> totalSupplierPush) {
        if (CommonUtil.isEmpty(totalSupplierPush)) {
            return ;
        }
        totalSupplierPush.forEach(this::createInquireSupplierPush);
    }

    /**
     * 确认询价推送
     * @param updateReqVO
     */
    void confirm(AppInquireSupplierPushConfirmReqVO updateReqVO);

    PageResult<AppInquireSupplierPushRespVO> getAppInquireSupplierPushPage(AppInquireSupplierPushPageReqVO pageReqVO);

    List<InquireSupplierPushDO> queryByInquireId(Long inquirePriceId, Long supplierId);

    List<InquireSupplierPushDO> queryByInquireId(Long inquirePriceId);
}