package cn.iocoder.foodnexus.module.operations.service.inquirepriceitem;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushDetailsRespVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirepriceitem.InquirePriceItemDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 询价管理子 Service 接口
 *
 * @author 超级管理员
 */
public interface InquirePriceItemService {

    /**
     * 创建询价管理子
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createInquirePriceItem(@Valid InquirePriceItemSaveReqVO createReqVO);

    /**
     * 更新询价管理子
     *
     * @param updateReqVO 更新信息
     */
    void updateInquirePriceItem(@Valid InquirePriceItemSaveReqVO updateReqVO);

    /**
     * 删除询价管理子
     *
     * @param id 编号
     */
    void deleteInquirePriceItem(Long id);

    /**
    * 批量删除询价管理子
    *
    * @param ids 编号
    */
    void deleteInquirePriceItemListByIds(List<Long> ids);

    /**
     * 获得询价管理子
     *
     * @param id 编号
     * @return 询价管理子
     */
    InquirePriceItemDO getInquirePriceItem(Long id);

    /**
     * 获得询价管理子分页
     *
     * @param pageReqVO 分页查询
     * @return 询价管理子分页
     */
    PageResult<InquirePriceItemDO> getInquirePriceItemPage(InquirePriceItemPageReqVO pageReqVO);

    void addOrUpdateBatch(Long inquireId, List<InquirePriceItemSaveReqVO> items, boolean isUpdate);

    List<InquirePriceItemDO> queryByInquireId(Long inquireId);

    Long queryCountByInquirePriceId(Long inquirePriceId);

    List<InquirePriceItemDO> queryByIds(Collection<Long> collection);

    default Map<Long, InquirePriceItemDO> queryMap(Collection<Long> collection) {
        return CommonUtil.listConvertMap(queryByIds(collection), InquirePriceItemDO::getId);
    }

    List<AppInquireSupplierPushDetailsRespVO.Items> queryListWithSupplierQuote(Long id, Long supplierId);
}