package cn.iocoder.foodnexus.module.operations.service.deliverystaff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.stream.StreamUtil;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaffcustomer.DeliveryStaffCustomerDO;
import cn.iocoder.foodnexus.module.operations.dal.mysql.deliverystaffcustomer.DeliveryStaffCustomerMapper;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaff.DeliveryStaffDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.operations.dal.mysql.deliverystaff.DeliveryStaffMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.operations.enums.ErrorCodeConstants.*;

/**
 * 配送员信息 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class DeliveryStaffServiceImpl implements DeliveryStaffService {

    @Resource
    private DeliveryStaffMapper deliveryStaffMapper;

    @Resource
    private DeliveryStaffCustomerMapper deliveryStaffCustomerMapper;

    @Override
    public Long createDeliveryStaff(DeliveryStaffSaveReqVO createReqVO) {
        // 插入
        DeliveryStaffDO deliveryStaff = BeanUtils.toBean(createReqVO, DeliveryStaffDO.class);
        deliveryStaffMapper.insert(deliveryStaff);

        // 返回
        return deliveryStaff.getId();
    }

    @Override
    public void updateDeliveryStaff(DeliveryStaffSaveReqVO updateReqVO) {
        // 校验存在
        validateDeliveryStaffExists(updateReqVO.getId());
        // 更新
        DeliveryStaffDO updateObj = BeanUtils.toBean(updateReqVO, DeliveryStaffDO.class);
        deliveryStaffMapper.updateById(updateObj);
    }

    @Override
    public void deleteDeliveryStaff(Long id) {
        // 校验存在
        validateDeliveryStaffExists(id);
        // 删除
        deliveryStaffMapper.deleteById(id);
    }

    @Override
        public void deleteDeliveryStaffListByIds(List<Long> ids) {
        // 删除
        deliveryStaffMapper.deleteByIds(ids);
        }


    private void validateDeliveryStaffExists(Long id) {
        if (deliveryStaffMapper.selectById(id) == null) {
            throw exception(DELIVERY_STAFF_NOT_EXISTS);
        }
    }

    @Override
    public DeliveryStaffDO getDeliveryStaff(Long id) {
        return deliveryStaffMapper.selectById(id);
    }

    @Override
    public PageResult<DeliveryStaffDO> getDeliveryStaffPage(DeliveryStaffPageReqVO pageReqVO) {
        return deliveryStaffMapper.selectPage(pageReqVO);
    }

    @Override
    public void bindCustomer(DeliveryStaffBindCustomerReqVO updateReqVO) {
        validateDeliveryStaffExists(updateReqVO.getStaffId());
        deliveryStaffCustomerMapper.delete(DeliveryStaffCustomerDO::getDeliveryStaffId, updateReqVO.getStaffId());
        if (CommonUtil.isNotEmpty(updateReqVO.getCustomerIdList())) {
            List<DeliveryStaffCustomerDO> deliveryStaffCustomerDOS = CommonUtil.listConvert(updateReqVO.getCustomerIdList(), customer -> {
                DeliveryStaffCustomerDO deliveryStaffCustomerDO = new DeliveryStaffCustomerDO();
                deliveryStaffCustomerDO.setCustomerId(customer);
                deliveryStaffCustomerDO.setDeliveryStaffId(updateReqVO.getStaffId());
                return deliveryStaffCustomerDO;
            });
            deliveryStaffCustomerMapper.insertBatch(deliveryStaffCustomerDOS);
        }
    }

    @Override
    public void bindCustomerRelease(Long id) {
        validateDeliveryStaffExists(id);
        deliveryStaffCustomerMapper.delete(DeliveryStaffCustomerDO::getDeliveryStaffId, id);
    }

}