package cn.iocoder.foodnexus.module.operations.service.deliverystaff;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.deliverystaff.DeliveryStaffDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 配送员信息 Service 接口
 *
 * @author 超级管理员
 */
public interface DeliveryStaffService {

    /**
     * 创建配送员信息
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createDeliveryStaff(@Valid DeliveryStaffSaveReqVO createReqVO);

    /**
     * 更新配送员信息
     *
     * @param updateReqVO 更新信息
     */
    void updateDeliveryStaff(@Valid DeliveryStaffSaveReqVO updateReqVO);

    /**
     * 删除配送员信息
     *
     * @param id 编号
     */
    void deleteDeliveryStaff(Long id);

    /**
    * 批量删除配送员信息
    *
    * @param ids 编号
    */
    void deleteDeliveryStaffListByIds(List<Long> ids);

    /**
     * 获得配送员信息
     *
     * @param id 编号
     * @return 配送员信息
     */
    DeliveryStaffDO getDeliveryStaff(Long id);

    /**
     * 获得配送员信息分页
     *
     * @param pageReqVO 分页查询
     * @return 配送员信息分页
     */
    PageResult<DeliveryStaffDO> getDeliveryStaffPage(DeliveryStaffPageReqVO pageReqVO);

    void bindCustomer(DeliveryStaffBindCustomerReqVO updateReqVO);

    void bindCustomerRelease(Long id);
}