package cn.iocoder.foodnexus.module.operations.dal.mysql.inquiresupplierpush;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushPageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushRespVO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirecustomerpush.InquireCustomerPushDO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquireprice.InquirePriceDO;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquiresupplierpush.InquireSupplierPushDO;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.inquiresupplierpush.vo.*;

/**
 * 询价推送 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface InquireSupplierPushMapper extends BaseMapperX<InquireSupplierPushDO> {

    default PageResult<InquireSupplierPushDO> selectPage(InquireSupplierPushPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<InquireSupplierPushDO>()
                .eqIfPresent(InquireSupplierPushDO::getSupplierId, reqVO.getSupplierId())
                .eqIfPresent(InquireSupplierPushDO::getInquirePriceId, reqVO.getInquirePriceId())
                .eqIfPresent(InquireSupplierPushDO::getProductId, reqVO.getProductId())
                .eqIfPresent(InquireSupplierPushDO::getCategoryId, reqVO.getCategoryId())
                .eqIfPresent(InquireSupplierPushDO::getSupplierQuote, reqVO.getSupplierQuote())
                .eqIfPresent(InquireSupplierPushDO::getConfirm, reqVO.getConfirm())
                .eqIfPresent(InquireSupplierPushDO::getConfirmUser, reqVO.getConfirmUser())
                .betweenIfPresent(InquireSupplierPushDO::getConfirmTime, reqVO.getConfirmTime())
                .betweenIfPresent(InquireSupplierPushDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(InquireSupplierPushDO::getId));
    }

    default PageResult<AppInquireSupplierPushRespVO> selectPage(AppInquireSupplierPushPageReqVO reqVO) {
        MPJLambdaWrapper<InquireSupplierPushDO> wrapper = new MPJLambdaWrapper<>();
        wrapper.selectAll(InquirePriceDO.class);
        wrapper.selectCount(InquireSupplierPushDO::getId, "inquirePriceItemCount");
        wrapper.selectAs(InquireCustomerPushDO::getConfirm, "isConfirm");
        wrapper.innerJoin(InquirePriceDO.class, InquirePriceDO::getId, InquireSupplierPushDO::getInquirePriceId);
        wrapper.eqIfExists(InquirePriceDO::getInquiryYearMonth, reqVO.getInquiryYearMonth());
        wrapper.eqIfExists(InquireSupplierPushDO::getConfirm, reqVO.getConfirm());
        wrapper.eq(InquireSupplierPushDO::getSupplierId, reqVO.getSupplierId());
        wrapper.eqIfExists(InquirePriceDO::getId, reqVO.getInquirePriceId());
        wrapper.groupBy(InquirePriceDO::getId);
        return selectJoinPage(reqVO, AppInquireSupplierPushRespVO.class, wrapper);
    }

    default List<InquireSupplierPushDO> queryQuoteByItemId(List<Long> itemIds) {
        LambdaQueryWrapperX<InquireSupplierPushDO> wrapperX = new LambdaQueryWrapperX<>();
        wrapperX.in(InquireSupplierPushDO::getInquirePriceItemId, itemIds);
        wrapperX.eq(InquireSupplierPushDO::getConfirm, Boolean.TRUE);
        return selectList(wrapperX);
    }
}