package cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.time.LocalDateTime;
import java.util.*;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 车辆信息新增/修改 Request VO")
@Data
public class VehicleInfoSaveReqVO {

    @Schema(description = "序号，自增主键", requiredMode = Schema.RequiredMode.REQUIRED, example = "7574")
    private Long id;

    @Schema(description = "车牌号", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "车牌号不能为空")
    private String licensePlate;

    @Schema(description = "车型", example = "2")
    private String vehicleType;

    @Schema(description = "载重 (kg)")
    private Integer loadWeight;

    @Schema(description = "容积 (m³)")
    private BigDecimal volume;

    @Schema(description = "备注", example = "你猜")
    private String remark;


    @Schema(description = "车架号")
    private String frameNumber;

    @Schema(description = "车辆品牌")
    private String vehicleBrand;

    @Schema(description = "保险有效期开始")
    private LocalDateTime insuranceBeginTime;

    @Schema(description = "保险有效期结束")
    private LocalDateTime insuranceEndTime;

    @Schema(description = "车辆图片")
    private String vehicleImage;

}