package cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 车辆信息 Response VO")
@Data
@ExcelIgnoreUnannotated
public class VehicleInfoRespVO {

    @Schema(description = "序号，自增主键", requiredMode = Schema.RequiredMode.REQUIRED, example = "7574")
    @ExcelProperty("序号，自增主键")
    private Long id;

    @Schema(description = "车牌号", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("车牌号")
    private String licensePlate;

    @Schema(description = "车型", example = "2")
    @ExcelProperty("车型")
    private String vehicleType;

    @Schema(description = "载重 (kg)")
    @ExcelProperty("载重 (kg)")
    private Integer loadWeight;

    @Schema(description = "容积 (m³)")
    @ExcelProperty("容积 (m³)")
    private BigDecimal volume;

    @Schema(description = "车辆绑定人员")
    @ExcelProperty("车辆绑定人员")
    private Long vehicleStaff;

    @Schema(description = "车辆绑定人员名称", example = "王五")
    @ExcelProperty("车辆绑定人员名称")
    private String vehicleStaffName;

    @Schema(description = "人员出生年份")
    @ExcelProperty("人员出生年份")
    private Integer staffYearBirth;

    @Schema(description = "人员联系方式")
    @ExcelProperty("人员联系方式")
    private String staffPhone;

    @Schema(description = "人员健康状态", example = "1")
    @ExcelProperty(value = "人员健康状态", converter = DictConvert.class)
    @DictFormat("oper_normal_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String staffHealthStatus;

    @Schema(description = "人员驾驶证状态", example = "2")
    @ExcelProperty(value = "人员驾驶证状态", converter = DictConvert.class)
    @DictFormat("oper_normal_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String staffLicenseStatus;

    @Schema(description = "备注", example = "你猜")
    @ExcelProperty("备注")
    private String remark;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "创建人")
    @ExcelProperty("创建人")
    private String creator;

    @Schema(description = "车架号")
    private String frameNumber;

    @Schema(description = "车辆品牌")
    private String vehicleBrand;

    @Schema(description = "保险有效期开始")
    private LocalDateTime insuranceBeginTime;

    @Schema(description = "保险有效期结束")
    private LocalDateTime insuranceEndTime;

    @Schema(description = "车辆图片")
    private String vehicleImage;


}