package cn.iocoder.foodnexus.module.operations.controller.admin.inquiresupplierpush.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

@Schema(description = "管理后台 - 询价推送新增/修改 Request VO")
@Data
public class InquireSupplierPushSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30131")
    private Long id;

    @Schema(description = "供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "17271")
    @NotNull(message = "供应商id不能为空")
    private Long supplierId;

    @Schema(description = "询价主题id", requiredMode = Schema.RequiredMode.REQUIRED, example = "20378")
    @NotNull(message = "询价主题id不能为空")
    private Long inquirePriceId;

    @Schema(description = "询价子id", requiredMode = Schema.RequiredMode.REQUIRED, example = "20378")
    @NotNull(message = "询价子id不能为空")
    private Long inquirePriceItemId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "3596")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "商品分类id", requiredMode = Schema.RequiredMode.REQUIRED, example = "2949")
    @NotNull(message = "商品分类id不能为空")
    private Long categoryId;

    @Schema(description = "供应商报价")
    private Integer supplierQuote;

    @Schema(description = "是否确认", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "是否确认不能为空")
    private Boolean confirm;

    @Schema(description = "确认人员")
    private Long confirmUser;

    @Schema(description = "确认时间")
    private LocalDateTime confirmTime;

}