package cn.iocoder.foodnexus.module.erp.service.customerwarehouse;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.erp.controller.admin.customerwarehouse.vo.*;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.customerwarehouse.CustomerWarehouseDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 客户绑定仓库 Service 接口
 *
 * @author 超级管理员
 */
public interface CustomerWarehouseService {

    /**
     * 创建客户绑定仓库
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCustomerWarehouse(@Valid CustomerWarehouseSaveReqVO createReqVO);

    /**
     * 更新客户绑定仓库
     *
     * @param updateReqVO 更新信息
     */
    void updateCustomerWarehouse(@Valid CustomerWarehouseSaveReqVO updateReqVO);

    /**
     * 删除客户绑定仓库
     *
     * @param id 编号
     */
    void deleteCustomerWarehouse(Long id);

    /**
    * 批量删除客户绑定仓库
    *
    * @param ids 编号
    */
    void deleteCustomerWarehouseListByIds(List<Long> ids);

    /**
     * 获得客户绑定仓库
     *
     * @param id 编号
     * @return 客户绑定仓库
     */
    CustomerWarehouseDO getCustomerWarehouse(Long id);

    /**
     * 获得客户绑定仓库分页
     *
     * @param pageReqVO 分页查询
     * @return 客户绑定仓库分页
     */
    PageResult<CustomerWarehouseDO> getCustomerWarehousePage(CustomerWarehousePageReqVO pageReqVO);

    /**
     * 根据客户id删除数据
     * @param customerId
     */
    void deleteByCustomerId(Long customerId);

    CustomerWarehouseDO getCustomerWarehouseByCustomerId(Long id);

    boolean exists(Long warehouseAreaId, Long customerId);
}