package cn.iocoder.foodnexus.module.erp.controller.admin.customerwarehouse.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 客户绑定仓库 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CustomerWarehouseRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "11798")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "24072")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "仓库id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30163")
    @ExcelProperty("仓库id")
    private Long warehouseId;

    @Schema(description = "库区id", requiredMode = Schema.RequiredMode.REQUIRED, example = "18079")
    @ExcelProperty("库区id")
    private Long warehouseAreaId;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}