package cn.iocoder.foodnexus.module.order.dal.mysql.checktaskitems;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.CheckTaskItemsPageReqVO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktaskitems.CheckTaskItemsDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.*;

/**
 * 来料质检清单 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CheckTaskItemsMapper extends BaseMapperX<CheckTaskItemsDO> {

    default PageResult<CheckTaskItemsDO> selectPage(CheckTaskItemsPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CheckTaskItemsDO>()
                .eqIfPresent(CheckTaskItemsDO::getCheckTaskId, reqVO.getCheckTaskId())
                .eqIfPresent(CheckTaskItemsDO::getProductId, reqVO.getProductId())
                .likeIfPresent(CheckTaskItemsDO::getProductName, reqVO.getProductName())
                .eqIfPresent(CheckTaskItemsDO::getCategoryId, reqVO.getCategoryId())
                .likeIfPresent(CheckTaskItemsDO::getCategoryName, reqVO.getCategoryName())
                .eqIfPresent(CheckTaskItemsDO::getPicUrl, reqVO.getPicUrl())
                .eqIfPresent(CheckTaskItemsDO::getCheckCount, reqVO.getCheckCount())
                .likeIfPresent(CheckTaskItemsDO::getUnitName, reqVO.getUnitName())
                .eqIfPresent(CheckTaskItemsDO::getCheckResult, reqVO.getCheckResult())
                .betweenIfPresent(CheckTaskItemsDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CheckTaskItemsDO::getId));
    }

}