package cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 购物车 Response VO")
@Data
@ExcelIgnoreUnannotated
public class ShoppingCartRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "12618")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7172")
    @ExcelProperty("商品id")
    private Long productId;

    @Schema(description = "商品名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "王五")
    @ExcelProperty("商品名称")
    private String productName;

    @Schema(description = "单价(分)", requiredMode = Schema.RequiredMode.REQUIRED, example = "6013")
    @ExcelProperty("单价(分)")
    private Integer unitPrice;

    @Schema(description = "下单数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("下单数量")
    private Integer orderQuantity;

    @Schema(description = "备注", example = "随便")
    @ExcelProperty("备注")
    private String remark;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}