package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 来料质检清单分页 Request VO")
@Data
public class CheckTaskItemsPageReqVO extends PageParam {

    @Schema(description = "来料质检id", example = "31590")
    private Long checkTaskId;

    @Schema(description = "商品id", example = "30398")
    private Long productId;

    @Schema(description = "商品名称", example = "王五")
    private String productName;

    @Schema(description = "商品分类", example = "20330")
    private Long categoryId;

    @Schema(description = "商品分类名称", example = "王五")
    private String categoryName;

    @Schema(description = "商品封面图", example = "https://www.iocoder.cn")
    private String picUrl;

    @Schema(description = "检查数量", example = "24148")
    private Integer checkCount;

    @Schema(description = "商品单位", example = "李四")
    private String unitName;

    @Schema(description = "质检结果")
    private String checkResult;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}