package cn.iocoder.foodnexus.module.order.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/9/5  17:12
 * @description: 客户 - 订单 - 状态
 */
@Getter
@AllArgsConstructor
public enum CustomerOrderStatus implements ArrayValuable<String> {

    // 下单成功
    ORDER_SUCCESS("下单成功", "ORDER_SUCCESS", 0) {
        @Override
        public String getText() {
            return "您已成功下单\n" +
                    "订单信息:订单金额:%s元，商品数量:%s件;";
        }
    },
    // 订单匹配
    ORDER_MATCH("订单匹配", "ORDER_MATCH", 1) {
        @Override
        public String getText() {
            return "【%s】供应商          匹配成功";
        }
    },
    // 供应商接单
    SUPPLIER_ACCEPT_ORDER("供应商接单", "SUPPLIER_ACCEPT_ORDER", 2) {
        @Override
        public String getText() {
            return "【%s】供应商          已接单";
        }
    },
    // 供应商发货
    SUPPLIER_SHIP("供应商发货", "SUPPLIER_SHIP", 3) {
        @Override
        public String getText() {
            return "【%s】供应商          已发货";
        }
    },
    // 供应商到货
    SUPPLIER_ARRIVE("供应商到货", "SUPPLIER_ARRIVE", 4) {
        @Override
        public String getText() {
            return "【%s】供应商          已到货";
        }
    },
    // 分仓质检
    WAREHOUSE_INSPECTION("分仓质检", "WAREHOUSE_INSPECTION", 5) {
        @Override
        public String getText() {
            return "您的商品已到达【%s】分仓，已完成质检入库;查看质检报告【%s】";
        }
    },
    // 商品分拣
    SORTING("商品分拣", "SORTING", 6) {
        @Override
        public String getText() {
            return "您的商品在【%s】分仓已完成分拣，【%s】正在进行配送";
        }
    },
    // 商品配送
    DELIVERY("商品配送", "DELIVERY", 7) {
        @Override
        public String getText() {
            return "您的商品将在16小时内完成配送，请保持电话畅通，配送员【%s】联系方式:【%s】";
        }
    },
    // 商品到货
    ARRIVAL("商品到货", "ARRIVAL", 8) {
        @Override
        public String getText() {
            return "您的商品已送到收货地址，请前往签收;配送员【%s】 联系方式:【%s】";
        }
    },
    // 商品签收
    SIGN_RECEIPT("商品签收", "SIGN_RECEIPT", 9) {
        @Override
        public String getText() {
            return "您的商品完成签收查看签收单【%s】";
        }
    },


    CANCEL("取消订单", "CANCEL", 9999) {
        @Override
        public String getText() {
            return "客户取消订单";
        }
    },

    ;

    private final String label;
    private final String key;
    private final int sort;

    public static final String[] ARRAYS = Arrays.stream(values()).map(CustomerOrderStatus::getKey).toArray(String[]::new);

    /**
     * @return 数组
     */
    @Override
    public String[] array() {
        return ARRAYS;
    }

    // 声明抽象方法
    public abstract String getText();
}
