package cn.iocoder.foodnexus.module.operations.controller.admin.inquiresupplierpush.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 询价推送分页 Request VO")
@Data
public class InquireSupplierPushPageReqVO extends PageParam {

    @Schema(description = "供应商id", example = "17271")
    private Long supplierId;

    @Schema(description = "询价主题id", example = "20378")
    private Long inquirePriceId;

    @Schema(description = "商品id", example = "3596")
    private Long productId;

    @Schema(description = "商品分类id", example = "2949")
    private Long categoryId;

    @Schema(description = "供应商报价")
    private Integer supplierQuote;

    @Schema(description = "是否确认")
    private Boolean confirm;

    @Schema(description = "确认人员")
    private Long confirmUser;

    @Schema(description = "确认时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] confirmTime;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}