package cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.api.vo.supplier.ErpSupplierFiles;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * ERP 供应商 DO
 *
 * @author 芋道源码
 */
@TableName(value = "erp_supplier", autoResultMap = true)
@KeySequence("erp_supplier_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpSupplierDO extends BaseDO {

    /**
     * 供应商编号
     */
    @TableId
    private Long id;
    /**
     * 供应商名称
     */
    private String name;
    /**
     * 联系人
     */
    private String contact;
    /**
     * 手机号码
     */
    private String mobile;
    /**
     * 联系电话
     */
    private String telephone;
    /**
     * 电子邮箱
     */
    private String email;
    /**
     * 传真
     */
    private String fax;
    /**
     * 备注
     */
    private String remark;
    /**
     * 开启状态
     *
     * 枚举 {@link cn.iocoder.foodnexus.framework.common.enums.CommonStatusEnum}
     */
    private Integer status;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 纳税人识别号
     */
    private String taxNo;
    /**
     * 税率
     */
    private BigDecimal taxPercent;
    /**
     * 开户行
     */
    private String bankName;
    /**
     * 开户账号
     */
    private String bankAccount;
    /**
     * 开户地址
     */
    private String bankAddress;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCreditCode;

    /**
     * 法人姓名
     */
    private String legalPerson;

    /**
     * 注册地址
     */
    private String registeredAddress;


    /**
     * 成立时间
     */
    private LocalDateTime establishmentTime;

    /**
     * 企业类型
     */
    private String enterpriseType;

    /**
     * 是否包括港澳台及外商投资等企业
     */
    private String isForeignRelated;

    /**
     * 经营商品类型
     */
    private String businessGoodsType;

    /**
     * 主要经营商品
     */
    private String mainBusinessGoods;

    /**
     * 保密资质或保密能力和条件描述
     */
    private String confidentialityQualification;

    /**
     * 副食品供应实践经验或与军队合作基础条件描述
     */
    private String nonStapleSupplyExperience;

    /**
     * 副食品筹措和保供能力描述
     */
    private String nonStapleSupplyCapacity;

    /**
     * 资质证明材料
     */
    @TableField(typeHandler = ErpSupplierFilesTypeHandler.class)
    private List<ErpSupplierFiles> files;

    /**
     * 审核状态
     */
    private String auditStatus;

    /**
     * 审核人（关联用户ID）
     */
    private Long auditor;

    /**
     * 审核时间
     */
    private LocalDateTime auditTime;

    /**
     * 审核意见
     */
    private String auditReason;

    /**
     * 关联部门id
     */
    private String systemDeptId;

}