package cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 订单评价分页 Request VO")
@Data
public class OrderScorePageReqVO extends PageParam {

    @Schema(description = "客户订单id", example = "4107")
    private Long orderId;

    @Schema(description = "评价指标id", example = "15052")
    private Long scoreId;

    @Schema(description = "评价指标名称", example = "芋艿")
    private String scoreName;

    @Schema(description = "供应商id", example = "23453")
    private Long supplierId;

    @Schema(description = "客户id", example = "7606")
    private Long customerId;

    @Schema(description = "得分")
    private Integer score;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}