package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 来料质检清单 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CheckTaskItemsRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "5717")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "来料质检id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31590")
    @ExcelProperty("来料质检id")
    private Long checkTaskId;

    @Schema(description = "采购订单子id")
    private Long purchaseOrderItemId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30398")
    @ExcelProperty("商品id")
    private Long productId;

    @Schema(description = "商品名称", example = "王五")
    @ExcelProperty("商品名称")
    private String productName;

    @Schema(description = "商品分类", example = "20330")
    @ExcelProperty("商品分类")
    private Long categoryId;

    @Schema(description = "商品分类名称", example = "王五")
    @ExcelProperty("商品分类名称")
    private String categoryName;

    @Schema(description = "商品封面图", requiredMode = Schema.RequiredMode.REQUIRED, example = "https://www.iocoder.cn")
    @ExcelProperty("商品封面图")
    private String picUrl;

    @Schema(description = "检查数量", requiredMode = Schema.RequiredMode.REQUIRED, example = "24148")
    @ExcelProperty("检查数量")
    private Integer checkCount;

    @Schema(description = "商品单位", example = "李四")
    @ExcelProperty("商品单位")
    private String unitName;

    @Schema(description = "质检结果", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty(value = "质检结果", converter = DictConvert.class)
    @DictFormat("order_check_task_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String checkResult;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}