package cn.iocoder.foodnexus.module.operations.dal.mysql.customerrequire;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.customerrequire.CustomerRequireDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo.*;

/**
 * 客户需求 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CustomerRequireMapper extends BaseMapperX<CustomerRequireDO> {

    default PageResult<CustomerRequireDO> selectPage(CustomerRequirePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<CustomerRequireDO>()
                .eqIfPresent(CustomerRequireDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(CustomerRequireDO::getRequireTitle, reqVO.getRequireTitle())
                .eqIfPresent(CustomerRequireDO::getRequireContent, reqVO.getRequireContent())
                .eqIfPresent(CustomerRequireDO::getCategoryId, reqVO.getCategoryId())
                .eqIfPresent(CustomerRequireDO::getIsRequire, reqVO.getIsRequire())
                .betweenIfPresent(CustomerRequireDO::getCreateTime, reqVO.getCreateTime())
                .betweenIfPresent(CustomerRequireDO::getUpdateTime, reqVO.getUpdateTime())
                .eqIfPresent(CustomerRequireDO::getCreator, reqVO.getCreator())
                .orderByDesc(CustomerRequireDO::getId));
    }

}