package cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 评分权重 Response VO")
@Data
@ExcelIgnoreUnannotated
public class ScoringWeightRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "8877")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "评价指标名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "赵六")
    @ExcelProperty("评价指标名称")
    private String scoreName;

    @Schema(description = "评分权重", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("评分权重")
    private BigDecimal weightRatio;

    @Schema(description = "是否展示", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("是否展示")
    private Boolean isDisplay;

    @Schema(description = "面向用户群体", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty(value = "面向用户群体", converter = DictConvert.class)
    @DictFormat("USER_SYSTEM") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String userSystem;

    @Schema(description = "排序")
    @ExcelProperty("排序")
    private Integer sort;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}