package cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 客户需求新增/修改 Request VO")
@Data
public class CustomerRequireSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "32398")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "23236", hidden = true)
    private Long customerId;

    @Schema(description = "需求标题", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "需求标题不能为空")
    private String requireTitle;

    @Schema(description = "需求内容")
    private String requireContent;

    @Schema(description = "商品分类编号", example = "28601")
    private Long categoryId;

}