package cn.iocoder.foodnexus.module.erp.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/9/25  14:58
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SaleOrderPickUpStatus implements ArrayValuable<String> {

    CANCEL("CANCEL", "取消"),

    TO_BE("TO_BE", "待拣"),

    PICK_UP("PICK_UP", "待接单"),

    ACCEPT("ACCEPT", "待配送"),

    ALREADY("ALREADY", "配送中"),

    ARRIVAL("ARRIVAL", "已到货"),

    SIGN("SIGN", "已签收"),

    /* ----- 退款 ------ */

    // 生成销售退货单
    RETURNS_PROCESS("RETURNS_PROCESS", "退款 - 审核中"),

    // 销售退货单申请通过
    RETURNS_APPROVE("RETURNS_APPROVE", "退款 - 已审核"),
    // 销售退货单根据供应商拆分为采购退货单

    // 配送员接受采购退货单
    RETURNS_STAFF_ACCEPT("RETURNS_STAFF_ACCEPT", "退款 - 配送员接单"),

    // 配送员取件发货
    RETURNS_STAFF_ALREADY("RETURNS_STAFF_ALREADY", "退款 - 配送员已取件"),

    // 确认收获
    RETURNS_FINISH("RETURNS_FINISH", "退款 - 退货完成"),

    ;

    public static final String[] ARRAYS = Arrays.stream(values()).map(SaleOrderPickUpStatus::getType).toArray(String[]::new);

    /**
     * 类型
     */
    private final String type;
    /**
     * 名字
     */
    private final String name;

    public static SaleOrderPickUpStatus getByType(String pickUpStatus) {
        if (CommonUtil.isBlank(pickUpStatus)) {
            return null;
        }
        for (SaleOrderPickUpStatus em : values()) {
            if (em.getType().equals(pickUpStatus)) {
                return em;
            }
        }
        return null;
    }

    @Override
    public String[] array() {
        return ARRAYS;
    }
}
