package cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.returns;

import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Schema(description = "管理后台 - ERP 采购退货新增/修改 Request VO")
@Data
public class ErpPurchaseReturnSaveReqVO {

    @Schema(description = "编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "17386")
    private Long id;

    @Schema(description = "结算账户编号", example = "31189")
    private Long accountId;

    @Schema(description = "退货时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "退货时间不能为空")
    private LocalDateTime returnTime;

    @Schema(description = "采购订单编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "17386")
    @NotNull(message = "采购订单编号不能为空")
    private Long orderId;

    @Schema(description = "附件地址", example = "https://www.iocoder.cn")
    private List<String> filesUrl;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "供应商id")
    private Long supplierId;

    /**
     * 枚举 {@link SaleOrderPickUpStatus}
     */
    @Schema(description = "退货状态")
    private String returnsStatus;

    @Schema(description = "客户收货地址id")
    private Long addressId;

    @Schema(description = "客户收货地址info")
    private CustomerAddressInfo addressInfo;

    @Schema(description = "收获仓库id")
    private Long warehouseId;

    @Schema(description = "收获库区id")
    private Long warehouseAreaId;

    @Schema(description = "仓库信息")
    private WarehouseInfo warehouseInfo;

    /**
     * DeliveryStaffDO
     */
    private Long deliveryStaffId;

    @Schema(description = "退货清单列表")
    private List<Item> items;

    @Data
    public static class Item {

        @Schema(description = "退货项编号", example = "11756")
        private Long id;

        @Schema(description = "采购订单项编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "11756")
        @NotNull(message = "采购订单项编号不能为空")
        private Long orderItemId;

        @Schema(description = "仓库编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "3113")
        @NotNull(message = "仓库编号不能为空")
        private Long warehouseId;

        @Schema(description = "产品编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "3113")
        @NotNull(message = "产品编号不能为空")
        private Long productId;

        @Schema(description = "产品单位单位", requiredMode = Schema.RequiredMode.REQUIRED, example = "3113")
        @NotNull(message = "产品单位单位不能为空")
        private String productUnit;

        @Schema(description = "产品单价", example = "100.00")
        private Integer productPrice;

        @Schema(description = "产品数量", requiredMode = Schema.RequiredMode.REQUIRED, example = "100.00")
        @NotNull(message = "产品数量不能为空")
        private Integer count;

        @Schema(description = "备注", example = "随便")
        private String remark;

        @Schema(description = "商品信息")
        private ProductInfo productInfo;

    }

}