package cn.iocoder.foodnexus.module.erp.api.service;

import cn.iocoder.foodnexus.module.erp.api.vo.customer.CustomerAddReqVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

import java.util.Collection;
import java.util.Map;

/**
 * @author : yanghao
 * create at:  2025/8/30  11:24
 * @description: 客户 api
 */
@Valid
public interface ErpCustomerApi {

    Long createByDept(Long deptId,@Valid @NotNull(message = "客户信息不能为空") CustomerAddReqVO customerAddReqVO);

    void updateByDept(Long deptId,@Valid @NotNull(message = "客户信息不能为空") CustomerAddReqVO customerAddReqVO);

    void deleteByDept(Long deptId);

    Long queryCustomerIdByUserId(Long userId);

    Map<Long, String> queryNameMapByIds(Collection<Long> collection);

    String queryNameStrById(Long customerId);
}
