package cn.iocoder.foodnexus.module.order.controller.app.customeraddress.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户 - 我的地址分页 Request VO")
@Data
public class CustomerAddressPageReqVO extends PageParam {

    @Schema(description = "客户id", example = "17120")
    private Long customerId;

    @Schema(description = "联系人")
    private String contactUser;

    @Schema(description = "联系号码")
    private String contactPhone;

    @Schema(description = "省id", example = "24818")
    private Long provinceId;

    @Schema(description = "省name", example = "李四")
    private String provinceName;

    @Schema(description = "市", example = "22031")
    private Long cityId;

    @Schema(description = "市", example = "张三")
    private String cityName;

    @Schema(description = "区", example = "3268")
    private Long regionId;

    @Schema(description = "区", example = "赵六")
    private String regionName;

    @Schema(description = "详细地址")
    private String address;

    @Schema(description = "是否默认")
    private Boolean isDefault;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "创建者", hidden = true)
    private Long creator;

}